<?php /*Template Name: form */ ?>
<?php get_header(); ?>
<h1 class="pagetit text-center">
    <?php the_title(); ?>
</h1>
<section class="content">
    <div class="container"
        <?php if (!empty(get_the_content()) || (has_post_thumbnail())): ?>
            <div class="page-main mb-5">
                <div class="container">
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="page-thumb text-center mb-2">
                            <?php the_post_thumbnail('full', ['class' => 'img-fluid mx-auto d-block']); ?>
                        </div>
                    <?php endif; ?>

                    <?php while (have_posts()) : the_post(); ?>
                        <div class="page-editor">
                            <?php the_content(); ?>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <div class="page-form">
        <div class="container">
            <p class="pyryhdfg wow fadeInUp" data-wow-delay=".2s">
                <?php _e('لا تتردد في مراسلتنا، فريقنا سيقوم بالرد عليك في أسرع وقت ممكن', 'm7md') ?>
            </p>
            <div class="row position-relative">
                <span class="lincont"></span>
                <div class="col-md-6">
                    <div class="form wow fadeInUp" data-wow-delay=".4s">

                        <?php echo do_shortcode('[contact-form-7 id="' . get_field('forms') . '" ]'); ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="frramemap wow fadeInUp" data-wow-delay=".6s">
                        <?php  the_field("mapfir","option") ?>
                    </div>
                </div>
            </div>
            <div class="contact-informationsa">
                <div class="itm-coinf wow fadeInUp" data-wow-delay=".2s">
                    <div class="iconitmcont">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M11.9999 13.4299C13.723 13.4299 15.1199 12.0331 15.1199 10.3099C15.1199 8.58681 13.723 7.18994 11.9999 7.18994C10.2768 7.18994 8.87988 8.58681 8.87988 10.3099C8.87988 12.0331 10.2768 13.4299 11.9999 13.4299Z" stroke="#0D47A1" stroke-width="1.5"/>
                            <path d="M3.6202 8.49C5.5902 -0.169998 18.4202 -0.159997 20.3802 8.5C21.5302 13.58 18.3702 17.88 15.6002 20.54C13.5902 22.48 10.4102 22.48 8.3902 20.54C5.6302 17.88 2.4702 13.57 3.6202 8.49Z" stroke="#0D47A1" stroke-width="1.5"/>
                        </svg>
                    </div>

                    <div class="contexfdf">
                        <h4><?php echo _e('الموقع', 'm7md') ?></h4>
                        <span class="value" ><?php the_field('address', 'option'); ?></span>
                    </div>
                </div>
                <div class="itm-coinf wow fadeInUp" data-wow-delay=".4s">

                    <div class="iconitmcont">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M2 8.5C2 5 4 3.5 7 3.5H17C20 3.5 22 5 22 8.5V15.5C22 19 20 20.5 17 20.5H7" stroke="#0D47A1" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M17 9L13.87 11.5C12.84 12.32 11.15 12.32 10.12 11.5L7 9" stroke="#0D47A1" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M2 16.5H8" stroke="#0D47A1" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M2 12.5H5" stroke="#0D47A1" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <div class="contexfdf">
                        <h4><?php echo _e('البريد الالكتروني', 'm7md') ?></h4>
                        <a class="value" target="_blank"
                           href="mailto:<?php the_field('email', 'option'); ?>">
                            <?php the_field('email', 'option'); ?>
                        </a>
                    </div>
                </div>
                <div class="itm-coinf wow fadeInUp" data-wow-delay=".6s">


                    <div class="iconitmcont">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M21.97 18.33C21.97 18.69 21.89 19.06 21.72 19.42C21.55 19.78 21.33 20.12 21.04 20.44C20.55 20.98 20.01 21.37 19.4 21.62C18.8 21.87 18.15 22 17.45 22C16.43 22 15.34 21.76 14.19 21.27C13.04 20.78 11.89 20.12 10.75 19.29C9.6 18.45 8.51 17.52 7.47 16.49C6.44 15.45 5.51 14.36 4.68 13.22C3.86 12.08 3.2 10.94 2.72 9.81C2.24 8.67 2 7.58 2 6.54C2 5.86 2.12 5.21 2.36 4.61C2.6 4 2.98 3.44 3.51 2.94C4.15 2.31 4.85 2 5.59 2C5.87 2 6.15 2.06 6.4 2.18C6.66 2.3 6.89 2.48 7.07 2.74L9.39 6.01C9.57 6.26 9.7 6.49 9.79 6.71C9.88 6.92 9.93 7.13 9.93 7.32C9.93 7.56 9.86 7.8 9.72 8.03C9.59 8.26 9.4 8.5 9.16 8.74L8.4 9.53C8.29 9.64 8.24 9.77 8.24 9.93C8.24 10.01 8.25 10.08 8.27 10.16C8.3 10.24 8.33 10.3 8.35 10.36C8.53 10.69 8.84 11.12 9.28 11.64C9.73 12.16 10.21 12.69 10.73 13.22C11.27 13.75 11.79 14.24 12.32 14.69C12.84 15.13 13.27 15.43 13.61 15.61C13.66 15.63 13.72 15.66 13.79 15.69C13.87 15.72 13.95 15.73 14.04 15.73C14.21 15.73 14.34 15.67 14.45 15.56L15.21 14.81C15.46 14.56 15.7 14.37 15.93 14.25C16.16 14.11 16.39 14.04 16.64 14.04C16.83 14.04 17.03 14.08 17.25 14.17C17.47 14.26 17.7 14.39 17.95 14.56L21.26 16.91C21.52 17.09 21.7 17.3 21.81 17.55C21.91 17.8 21.97 18.05 21.97 18.33Z" stroke="#0D47A1" stroke-width="1.5" stroke-miterlimit="10"/>
                            <path opacity="0.4" d="M18.5 9C18.5 8.4 18.03 7.48 17.33 6.73C16.69 6.04 15.84 5.5 15 5.5" stroke="#0D47A1" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            <path opacity="0.4" d="M22 9C22 5.13 18.87 2 15 2" stroke="#0D47A1" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <div class="contexfdf">
                        <h4><?php echo _e('رقم الجوال', 'm7md') ?></h4>
                        <a class="value" target="_blank"
                           href="tel:<?php the_field('phone', 'option'); ?>">
                            <?php the_field('phone', 'option'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

</section>
<script>
    jQuery(document).ready(function($) {

        var totalHeight = 0;

        $('.form-focused.form-group').each(function () {

            var $el = $(this);

            var h = $el.outerHeight();                        // height + padding + border
            var mt = parseFloat($el.css('margin-top')) || 0;  // margin-top
            var mb = parseFloat($el.css('margin-bottom')) || 0; // margin-bottom

            totalHeight += (h + mt + mb);
        });

        // ضع ارتفاع للـ iframe
        $('iframe , .lincont').height(totalHeight - 20 );
    });

</script>
<?php get_footer(); ?>
